# 대칭키 & 공개키

두 방식은 네크워크 상에서 어떤 메세지를 보내거나 받을 때 사용하는 대표적인 두가지 암호화 방식이다.

<br>

**알아야 할 용어**
- 기밀성 : 자원의 노출을 방지하는 것이다.
- 무결성 : 자원의 변경을 방지하는 것이다.
- 부인 방지 : 송신자나 수신자가 메시지를 주고받은 사실을 부인하지 못하도록 방지하는 것이다. 

<br>

## 공개키, 개인키
- 비밀키: 대칭키 암호 방식에서 데이터 암호화와 복호화를 위해 둘 혹은 그 이상의 사용자 간에 동일하게 공유하는 단일 키.
- 공개키: 공개키 암호 방식에서 사용되는 비대칭 키 쌍(공개 키, 개인 키) 중에서 공개되는 키
- 개인키: 공개키 암호 방식에서 사용되는 비대칭 키 쌍(공개 키, 개인 키) 중에서 공개되지 않고 비밀리에 사용하는 키

<br>

## 대칭키 암호화

대칭키 암호화 방식은 **암호화, 복호화시 같은 키(비밀키)를 사용**한다.(single-key-encryption)  
데이터를 저장하거나 전송할 때 기밀성을 갖도록 암호화를 사용한다.  
대칭키 암호화 방식에서는 키를 어떻게 교환하는가가 핵심이다.  
<br>
<img src="https://user-images.githubusercontent.com/102718303/208462210-3751b68e-631d-4ca3-940a-646dd566cac7.png" alt="single-key-encryption" width="500px" />

<br>

### 대칭키 암호화 방식
기밀성을 제공한다.
1. 평문 input
2. 키와 암호화 알고리즘을 사용해 암호문 생성
3. 수신자는 암호문을 받아서 동일한 키와 알고리즘을 사용하여 복호화한다.
4. 평문 output

<br>

### 대칭키 암호화 알고리즘
- **DES**
  - `64 bit의 블록`을 이용해 암호화 하며, `암호 키\* 길이는 56 bit`이다.
  - 2개의 p-박스(초기 전치, 최종 전치), `16개의 라운드 함수`로 구성된다.
  - `초기 전치`는 라운드 함수가 시작되기 전 암호화 시작 부분에 있는 p-박스이고, `최종 전치`는 라운드 함수가 전부 끝난 후 암호화 끝 부분에 있는 p-박스이다.
  - 암호 키(56bit)는 Round-key generator에 의해 각 라운드마다 서로 다른 서브키(48bit)를 생성하게 된다.
  - 이 서브키는 각 라운드에 라운드 키\*로 사용된다.  
  <img src="https://user-images.githubusercontent.com/102718303/208465367-c36e5f96-f46b-4b97-a52a-c72f654fba1e.png" alt="DES" width="500px" />

- **AES**
  - `128 bit의 블록`을 이용해 암호화 하며, `암호 키\* 길이는 128/192/256 bit`이다.
  - 고정된 라운드 수와 키 길이를 갖는 DES와 달리, AES는 `10/12/14개의 라운드 함수`와 대응하는 `키 길이 128/192/256 bit`를 갖는다.
  - 암호 키(128/192/256 bit)는 Round-key generator에 의해 각 라운드마다 서로 다른 서브키(128 bit)를 생성하게 된다.
    - 암호 키의 길이는 달라도 라운드 키는 모두 128 bit이다.
  - DES 보다 안전하다.
  - 마지막 라운드를 제외한 각 라운드에서 4가지 연산(바이트 대체, 행 이동, 열 섞기, 라운드 키 더하기)을 이용해서 데이터 블록 전체를 처리한다.  
  <div>
    <img src="https://postfiles.pstatic.net/MjAxOTExMThfMTk2/MDAxNTc0MDU0MTEzMzU0.HDnHyeJWnL6ccsEBIEyy560n095iG7rPW4bNsnD7XEYg.1OyEsUHA2G-eVTV7xquOe8eBWUzYD_X_kTv4-dkzn88g.JPEG.wnrjsxo/aes_structure.jpg?type=w773" alt="AES" height="400px">
    <img src="https://user-images.githubusercontent.com/102718303/208461812-5cabaaf5-6a67-4bf0-8a13-52861691aa38.png" alt="AES" height="400px" />
  </div>

_\*암호 키: 초기 비밀키_
_\*라운드 키: 특정 라운드에서 사용되는 키_

<br>

### 장점 및 단점
* **장점**
  - 암호화 속도가 빨라, 대용량 데이터 암호화에 적합하다.
  - 기밀성을 제공한다.

* **단점**
  - 강한 보안을 위해 키를 주기적으로 교환해주는 것이 좋다.
  - 사람이 많아질수록 키 관리가 더 어려워진다. (사람마다 별도의 비밀키를 관리해야 하기 때문이다.)
  - 부인 방지를 보장하지 않는다.

<br>
<br>

## 공개키 암호화
공개키 암호화 방식은 **암호화, 복호화시 서로 다른 키(공개키, 개인키)를 사용**한다.(public-key encryption)  
공개키로 암호화 된 경우 개인키로만 복호화를 할 수 있다.(공개키로 복호화는 불가능하다.)  
공개키는 말그대로 모두에게 공개되어 있는 키이고, 개인키는 본인만이 알고있고, 가지고 있는 키이다.  

<br>

### 공개키 암호화 방식
* **암호화시 공개키를 사용하는 경우**  
  기밀성을 제공한다. 즉, 데이터를 안전하게 전송할 수 있다.
  1. 평문 input
  2. 수신자의 공개키와 암호화 알고리즘을 사용해 암호문 생성
  3. 수신자는 암호문을 받아서 수신자의 개인키와 복호화 알고리즘을 사용한다.
  4. 평문 output
* **암호화시 개인키를 사용하는 경우**  
  무결성을 제공한다. 즉, 신뢰할 수 있는 단체라는 것을 인증한다.
  1. 평문 input
  2. 발신자의 개인키와 암호화 알고리즘을 사용해 암호문 생성
  3. 수신자는 암호문을 받아서 발신자의 공개키와 복호화 알고리즘을 사용한다.
  4. 평문 output

<br>

### 공개키 암호화 알고리즘
- **RSA**
  - 암호화, 전자 서명에 사용된다.
  - 송신자가 수신자에게 공개키를 요청하면, 수신자는 자신의 공개키를 송신자에게 전송한다. 송신자는 수신자로부터 받은 공개키를 이용해 평문을 암호화 한 후 수신자에게 전송한다. 
  - 수신자는 개인키를 이용해 헤당 암호문을 복호화한다.
  - RSA의 암호화체계의 안정성은 큰 숫자를 소인수 분해하는 것이 어렵다는 것에 기반을 두고 있다.  
  <img src="https://user-images.githubusercontent.com/102718303/208467825-a3641ee5-c20c-4c65-a583-6b502182c03c.png" alt="RSA" width="500px" />


- **Diffie-Hellman**
  - 키 교환 알고리즘이다.
  - 상대방의 공개키와 자신의 개인키를 이용하여 비밀키를 만들고, 서로 비밀키를 사용하여 데이터를 암호화하여 전달한다.
  - DH 알고리즘에서 공개키와 개인키를 오직 비밀키를 얻는데에 사용된다.
  - Diffie-Hellman의 키 교환 암호화 알고리즘의 안전성은 이산대수 문제 (discrete log problem)에 달려있다.
  <img src="https://user-images.githubusercontent.com/102718303/208468623-3efae7b0-dbba-404c-b38d-21fe3c9bc0a7.png" alt="Diffie-Hellman" width="500px" />

<br>

### 장점 및 단점
* **장점**
  - 키 분배 및 관리가 용이하다.
  - 기밀성, 무결성을 제공한다.
  - 부인 방지 기능을 제공한다. (개인키로 암호화 하는 경우, 수신자는 발신자의 공개키로만 해독이 가능하므로 수신자가 보낸 증거가 된다.)

* **단점**
  - 상대적으로 키의 길이가 길다.
  - 암복호화 연산 속도가 느리다.

>**HTTPS**는 대칭키 암호화와 공개키 암호화 방식 모두 사용한다.

<br>

---

## Refrence
- https://www.uname.in/129
- https://velog.io/@gs0351/%EB%8C%80%EC%B9%AD%ED%82%A4-vs-%EA%B3%B5%EA%B0%9C%ED%82%A4%EB%B9%84%EB%8C%80%EC%B9%AD%ED%82%A4
- https://universitytomorrow.com/22
- https://jaehoney.tistory.com/290
- https://velog.io/@octo__/%EB%8C%80%EC%B9%AD%ED%82%A4%EC%99%80-%EA%B3%B5%EA%B0%9C%ED%82%A4%EB%B9%84%EB%8C%80%EC%B9%AD%ED%82%A4
- https://liveyourit.tistory.com/196
- https://developer-mac.tistory.com/76
- http://terms.tta.or.kr/mobile/searchFirstList.do